import matplotlib.pyplot as p
import numpy as np

def run():

    weights = [[-0.96, -1.2, -2.31, 4.67, 0.01, 4.94, -4.28, -2.43, 5.0, -0.07, 4.26, 4.98, 0.36, 3.0, 2.66, -2.33, 0.89, 0.05, 0.98, 0.2, -5.0, 5.0, 5.0, 5.0, 4.75, -5.0, -5.0, 4.01, 4.52, 5.0, -0.77, 0.37, -0.24, -0.94, 0.19, 1.07, 1.83, 5.0, -4.78, 2.64, 1.02, 4.88, 0.49, 5.0, 4.14, 4.46, -2.54, 4.64, 1.83, 5.0, 1.32, 2.02, 2.66, -1.74, 4.07, 5.0, 0.86, 381.43, 1.0, 1.0, 72.35, 12.8, 1.0, 1.0, -1.0, -0.64, -0.94, 1.0, 1.0, -0.06, -1.0, -0.76, 1.0, -0.24, 0.88]]

    t3 = [1,2,3]
    t2 = [1,2]
    t6 = [0,3,6]
    t10 = [0,5,10]
    t25 = [0,12.5,25]
    t30 = [0,15,30]
    t40 = [0,20,40]
    t50 = [0,25,50]
    t70 = [0,35,70]
    t100 = [0,50,100]
    t200 = [0,100,200]
    tcont = np.arange(50)

    for w in weights:

        # 1st set of plots - Explore mode
        p.figure(figsize=(20,10))
        # 1st plot - Agent
        p.subplot(241)
        p.plot(t25,w[0:3])
        p.title("Closest Agent")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest agent")
        p.ylabel("Movement to closest agent")
        p.subplot(245)
        p.plot(t25,w[3:6])
        p.title("Closest Agent")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest agent")
        p.ylabel("Movement parallel to closest bot")
        # 2nd plot - Mine
        p.subplot(242)
        p.plot(t25,w[18:21])
        p.title("Closest Mine")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest mine")
        p.ylabel("Movement to closest mine")
        p.subplot(246)
        p.plot(t25,w[21:24])
        p.title("Closest Mine")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest mine")
        p.ylabel("Movement parallel to closest mine")
        # 3rd plot - Base
        p.subplot(243)
        p.plot(t30,w[36:39])
        p.title("Base")
        p.axis([0,30,-6,6])
        p.xlabel("Distance to base")
        p.ylabel("Movement to base")
        p.subplot(247)
        p.plot(t30,w[39:42])
        p.title("Base")
        p.axis([0,30,-6,6])
        p.xlabel("Distance to base")
        p.ylabel("Movement parallel to base")
        # 4th plot - Center
        p.subplot(244)
        x = w[57]
        y = w[54]
        p.plot([0,x,2*x,1000],[0,0,y,((float(1000)-x)/x)*y])
        p.title("Center")
        p.axis([0,1000,-6,6])
        p.ylabel("Movement to center")
        p.xlabel("Distance to center")

        # 2nd set of plots - Report mode
        p.figure(figsize=(20,10))
        # 1st plot - Agent
        p.subplot(241)
        p.plot(t25,w[6:9])
        p.title("Closest Agent")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest agent")
        p.ylabel("Movement to closest agent")
        p.subplot(245)
        p.plot(t25,w[9:12])
        p.title("Closest Agent")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest agent")
        p.ylabel("Movement parallel to closest bot")
        # 2nd plot - Mine
        p.subplot(242)
        p.plot(t25,w[24:27])
        p.title("Closest Mine")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest mine")
        p.ylabel("Movement to closest mine")
        p.subplot(246)
        p.plot(t25,w[27:30])
        p.title("Closest Mine")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest mine")
        p.ylabel("Movement parallel to closest mine")
        # 3rd plot - Base
        p.subplot(243)
        p.plot(t30,w[42:45])
        p.title("Base")
        p.axis([0,30,-6,6])
        p.xlabel("Distance to base")
        p.ylabel("Movement to base")
        p.subplot(247)
        p.plot(t30,w[45:48])
        p.title("Base")
        p.axis([0,30,-6,6])
        p.xlabel("Distance to base")
        p.ylabel("Movement parallel to base")
        # 4th plot - Center
        p.subplot(244)
        x = w[58]
        y = w[55]
        p.plot([0,x,2*x,1000],[0,0,y,((float(1000)-x)/x)*y])
        p.title("Center")
        p.axis([0,1000,-6,6])
        p.ylabel("Movement to center")
        p.xlabel("Distance to center")

        # 3rd set of plots - Recharge mode
        p.figure(figsize=(20,10))
        # 1st plot - Agent
        p.subplot(241)
        p.plot(t25,w[12:15])
        p.title("Closest Agent")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest agent")
        p.ylabel("Movement to closest agent")
        p.subplot(245)
        p.plot(t25,w[15:18])
        p.title("Closest Agent")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest agent")
        p.ylabel("Movement parallel to closest bot")
        # 2nd plot - Mine
        p.subplot(242)
        p.plot(t25,w[30:33])
        p.title("Closest Mine")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest mine")
        p.ylabel("Movement to closest mine")
        p.subplot(246)
        p.plot(t25,w[33:36])
        p.title("Closest Mine")
        p.axis([0,25,-6,6])
        p.xlabel("Distance to closest mine")
        p.ylabel("Movement parallel to closest mine")
        # 3rd plot - Base
        p.subplot(243)
        p.plot(t30,w[48:51])
        p.title("Base")
        p.axis([0,30,-6,6])
        p.xlabel("Distance to base")
        p.ylabel("Movement to base")
        p.subplot(247)
        p.plot(t30,w[51:54])
        p.title("Base")
        p.axis([0,30,-6,6])
        p.xlabel("Distance to base")
        p.ylabel("Movement parallel to base")
        # 4th plot - Center
        p.subplot(244)
        x = w[59]
        y = w[56]
        p.plot([0,x,2*x,1000],[0,0,y,((float(1000)-x)/x)*y])
        p.title("Center")
        p.axis([0,1000,-6,6])
        p.ylabel("Movement to center")
        p.xlabel("Distance to center")

        # 4th set of plots - Recharging Decisions
        p.figure(figsize=(15,5))
        # 1st plot - Battery Full - Recharge -> Explore
        p.subplot(131)
        t = w[60]
        p.plot([0,100],[t,t],'b')
        p.plot([0,100],[0,100],'r')
        p.title("Recharge -> Explore")
        p.axis([0,100,0,100])
        p.xlabel("Battery recharging")
        p.ylabel("When the agent decides to switch")
        # 2nd plot - Explore -> Recharge
        p.subplot(132)
        t = w[61]
        p.plot([0,50],[t,t],'b')
        p.plot([0,50],[50,0],'r')
        p.title("Explore -> Recharge")
        p.axis([0,50,0,50])
        p.xlabel("Battery remaining after relD")
        p.ylabel("When the agent decides to switch")
        # 3rd plot - Report -> Recharge
        p.subplot(133)
        t = w[62]
        p.plot([0,50],[t,t],'b')
        p.plot([0,50],[50,0],'r')
        p.title("Report -> Recharge")
        p.axis([0,50,0,50])
        p.xlabel("Battery remaining after relD")
        p.ylabel("When the agent decides to switch")

        # 5th set of plots - Handoff Decisions
        p.figure(figsize=(15,10))
        # 1st plot - Battery - Explorer sees mine
        p.subplot(231)
        t = w[69]
        wt = w[63]
        if (t < 0 and wt < 0) or (t > 0 and wt > 0):
            p.plot(t100,[0,50*wt,100*wt])
            p.plot(t100,[t,t,t])
            p.title("Battery allows Explorer + mine -> Reporter")
            if t < 0 and wt < 0:
                p.axis([0,100,-100,0])
            else:
                p.axis([0,100,0,100])
            p.xlabel("Battery remaining after relD")
            p.ylabel("Weighted Bat and threshold")
        elif t < 0 and wt > 0:
            p.plot(t100,[t,t,t])
            p.title("Battery always allows Explorer + mine -> Reporter")
        else:
            p.plot(t100,[t,t,t])
            p.title("Battery never allows Explorer + mine -> Reporter")
        # 2nd plot - Battery - Explorer hears broadcast
        p.subplot(232)
        t = w[71]
        wt = w[65]
        if (t < 0 and wt < 0) or (t > 0 and wt > 0):
            p.plot(t100,[0,50*wt,100*wt])
            p.plot(t100,[t,t,t])
            p.title("Battery allows Explorer + Bcast -> Reporter")
            if t < 0 and wt < 0:
                p.axis([0,100,-100,0])
            else:
                p.axis([0,100,0,100])
            p.xlabel("Battery remaining after relD")
            p.ylabel("Weighted Bat and threshold")
        elif t < 0 and wt > 0:
            p.plot(t100,[t,t,t])
            p.title("Battery always allows Explorer + Bcast -> Reporter")
        else:
            p.plot(t100,[t,t,t])
            p.title("Battery never allows Explorer + Bcast -> Reporter")
        # 3rd plot - Battery - Reporter sees explorer
        p.subplot(233)
        t = w[73]
        wt = w[67]
        if (t < 0 and wt < 0) or (t > 0 and wt > 0):
            p.plot(t100,[0,50*wt,100*wt])
            p.plot(t100,[t,t,t])
            p.title("Battery allows Reporter -> Bcast")
            if t < 0 and wt < 0:
                p.axis([0,100,-100,0])
            else:
                p.axis([0,100,0,100])
            p.xlabel("Battery remaining after relD")
            p.ylabel("Weighted Bat and threshold")
        elif t < 0 and wt > 0:
            p.plot(t100,[t,t,t])
            p.title("Battery always allows Explorer -> Bcast")
        else:
            p.plot(t100,[t,t,t])
            p.title("Battery never allows Explorer -> Bcast")
        # 4th plot - Agents - Explorer sees mine
        p.subplot(234)
        t = w[70]
        wt = w[64]
        if (t < 0 and wt < 0) or (t > 0 and wt > 0):
            p.plot(t10,[0,5*wt,10*wt])
            p.plot(t10,[t,t,t])
            p.title("#Agents allows Explorer + mine -> Reporter")
            if t < 0 and wt < 0:
                p.axis([0,10,-10,0])
            else:
                p.axis([0,10,0,10])
            p.xlabel("#Agents")
            p.ylabel("Weighted #Agents and threshold")
        elif t < 0 and wt > 0:
            p.plot(t10,[t,t,t])
            p.title("#Agents always allows Explorer + mine -> Reporter")
        else:
            p.plot(t10,[t,t,t])
            p.title("#Agents never allows Explorer + mine -> Reporter")
        # 5th plot - Agents - Explorer hears broadcast
        p.subplot(235)
        t = w[72]
        wt = w[66]
        if (t < 0 and wt < 0) or (t > 0 and wt > 0):
            p.plot(t10,[0,5*wt,10*wt])
            p.plot(t10,[t,t,t])
            p.title("#Agents allows Explorer + Bcast -> Reporter")
            if t < 0 and wt < 0:
                p.axis([0,10,-10,0])
            else:
                p.axis([0,10,0,10])
            p.xlabel("#Agents")
            p.ylabel("Weighted #Agents and threshold")
        elif t < 0 and wt > 0:
            p.plot(t10,[t,t,t])
            p.title("#Agents always allows Explorer + Bcast -> Reporter")
        else:
            p.plot(t10,[t,t,t])
            p.title("#Agents never allows Explorer + Bcast -> Reporter")
        # 6th plot - Agents - Reporter sees explorer
        p.subplot(236)
        t = w[74]
        wt = w[68]
        if (t < 0 and wt < 0) or (t > 0 and wt > 0):
            p.plot(t10,[0,5*wt,10*wt])
            p.plot(t10,[t,t,t])
            p.title("#Agents allows Reporter -> Bcast")
            if t < 0 and wt < 0:
                p.axis([0,10,-10,0])
            else:
                p.axis([0,10,0,10])
            p.xlabel("#Agents")
            p.ylabel("Weighted #Agents and threshold")
        elif t < 0 and wt > 0:
            p.plot(t10,[t,t,t])
            p.title("#Agents always allows Explorer -> Bcast")
        else:
            p.plot(t10,[t,t,t])
            p.title("#Agents never allows Explorer -> Bcast")

    p.show()

run()
